/*!
 * # Semantic UI 2.2.6 - Popup
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(t,e,o,n){"use strict";e="undefined"!=typeof e&&e.Math==Math?e:"undefined"!=typeof self&&self.Math==Math?self:Function("return this")(),t.fn.popup=function(i){var r,a=t(this),s=t(o),p=t(e),l=t("body"),u=a.selector||"",c=!0,d=(new Date).getTime(),f=[],g=arguments[0],h="string"==typeof g,m=[].slice.call(arguments,1);return a.each(function(){var a,v,b,w,y,C,T=t.isPlainObject(i)?t.extend(!0,{},t.fn.popup.settings,i):t.extend({},t.fn.popup.settings),P=T.selector,x=T.className,k=T.error,S=T.metadata,E=T.namespace,A="."+T.namespace,D="module-"+E,O=t(this),j=t(T.context),F=t(T.scrollContext),R=t(T.boundary),H=T.target?t(T.target):O,N=0,M=!1,W=!1,G=this,I=O.data(D);C={initialize:function(){C.debug("Initializing",O),C.createID(),C.bind.events(),!C.exists()&&T.preserve&&C.create(),T.observeChanges&&C.observeChanges(),C.instantiate()},instantiate:function(){C.verbose("Storing instance",C),I=C,O.data(D,I)},observeChanges:function(){"MutationObserver"in e&&(b=new MutationObserver(C.event.documentChanged),b.observe(o,{childList:!0,subtree:!0}),C.debug("Setting up mutation observer",b))},refresh:function(){T.popup?a=t(T.popup).eq(0):T.inline&&(a=H.nextAll(P.popup).eq(0),T.popup=a),T.popup?(a.addClass(x.loading),v=C.get.offsetParent(),a.removeClass(x.loading),T.movePopup&&C.has.popup()&&C.get.offsetParent(a)[0]!==v[0]&&(C.debug("Moving popup to the same offset parent as activating element"),a.detach().appendTo(v))):v=T.inline?C.get.offsetParent(H):C.has.popup()?C.get.offsetParent(a):l,v.is("html")&&v[0]!==l[0]&&(C.debug("Setting page as offset parent"),v=l),C.get.variation()&&C.set.variation()},reposition:function(){C.refresh(),C.set.position()},destroy:function(){C.debug("Destroying previous module"),b&&b.disconnect(),a&&!T.preserve&&C.removePopup(),clearTimeout(C.hideTimer),clearTimeout(C.showTimer),C.unbind.close(),C.unbind.events(),O.removeData(D)},event:{start:function(e){var o=t.isPlainObject(T.delay)?T.delay.show:T.delay;clearTimeout(C.hideTimer),W||(C.showTimer=setTimeout(C.show,o))},end:function(){var e=t.isPlainObject(T.delay)?T.delay.hide:T.delay;clearTimeout(C.showTimer),C.hideTimer=setTimeout(C.hide,e)},touchstart:function(t){W=!0,C.show()},resize:function(){C.is.visible()&&C.set.position()},documentChanged:function(e){[].forEach.call(e,function(e){e.removedNodes&&[].forEach.call(e.removedNodes,function(e){(e==G||t(e).find(G).length>0)&&(C.debug("Element removed from DOM, tearing down events"),C.destroy())})})},hideGracefully:function(e){var n=t(e.target),i=t.contains(o.documentElement,e.target),r=n.closest(P.popup).length>0;e&&!r&&i?(C.debug("Click occurred outside popup hiding popup"),C.hide()):C.debug("Click was inside popup, keeping popup open")}},create:function(){var e=C.get.html(),o=C.get.title(),n=C.get.content();e||n||o?(C.debug("Creating pop-up html"),e||(e=T.templates.popup({title:o,content:n})),a=t("<div/>").addClass(x.popup).data(S.activator,O).html(e),T.inline?(C.verbose("Inserting popup element inline",a),a.insertAfter(O)):(C.verbose("Appending popup element to body",a),a.appendTo(j)),C.refresh(),C.set.variation(),T.hoverable&&C.bind.popup(),T.onCreate.call(a,G)):0!==H.next(P.popup).length?(C.verbose("Pre-existing popup found"),T.inline=!0,T.popup=H.next(P.popup).data(S.activator,O),C.refresh(),T.hoverable&&C.bind.popup()):T.popup?(t(T.popup).data(S.activator,O),C.verbose("Used popup specified in settings"),C.refresh(),T.hoverable&&C.bind.popup()):C.debug("No content specified skipping display",G)},createID:function(){y=(Math.random().toString(16)+"000000000").substr(2,8),w="."+y,C.verbose("Creating unique id for element",y)},toggle:function(){C.debug("Toggling pop-up"),C.is.hidden()?(C.debug("Popup is hidden, showing pop-up"),C.unbind.close(),C.show()):(C.debug("Popup is visible, hiding pop-up"),C.hide())},show:function(t){if(t=t||function(){},C.debug("Showing pop-up",T.transition),C.is.hidden()&&(!C.is.active()||!C.is.dropdown())){if(C.exists()||C.create(),T.onShow.call(a,G)===!1)return void C.debug("onShow callback returned false, cancelling popup animation");T.preserve||T.popup||C.refresh(),a&&C.set.position()&&(C.save.conditions(),T.exclusive&&C.hideAll(),C.animate.show(t))}},hide:function(t){if(t=t||function(){},C.is.visible()||C.is.animating()){if(T.onHide.call(a,G)===!1)return void C.debug("onHide callback returned false, cancelling popup animation");C.remove.visible(),C.unbind.close(),C.restore.conditions(),C.animate.hide(t)}},hideAll:function(){t(P.popup).filter("."+x.visible).each(function(){t(this).data(S.activator).popup("hide")})},exists:function(){return!!a&&(T.inline||T.popup?C.has.popup():a.closest(j).length>=1)},removePopup:function(){C.has.popup()&&!T.popup&&(C.debug("Removing popup",a),a.remove(),a=n,T.onRemove.call(a,G))},save:{conditions:function(){C.cache={title:O.attr("title")},C.cache.title&&O.removeAttr("title"),C.verbose("Saving original attributes",C.cache.title)}},restore:{conditions:function(){return C.cache&&C.cache.title&&(O.attr("title",C.cache.title),C.verbose("Restoring original attributes",C.cache.title)),!0}},supports:{svg:function(){return typeof SVGGraphicsElement===n}},animate:{show:function(e){e=t.isFunction(e)?e:function(){},T.transition&&t.fn.transition!==n&&O.transition("is supported")?(C.set.visible(),a.transition({animation:T.transition+" in",queue:!1,debug:T.debug,verbose:T.verbose,duration:T.duration,onComplete:function(){C.bind.close(),e.call(a,G),T.onVisible.call(a,G)}})):C.error(k.noTransition)},hide:function(e){return e=t.isFunction(e)?e:function(){},C.debug("Hiding pop-up"),T.onHide.call(a,G)===!1?void C.debug("onHide callback returned false, cancelling popup animation"):void(T.transition&&t.fn.transition!==n&&O.transition("is supported")?a.transition({animation:T.transition+" out",queue:!1,duration:T.duration,debug:T.debug,verbose:T.verbose,onComplete:function(){C.reset(),e.call(a,G),T.onHidden.call(a,G)}}):C.error(k.noTransition))}},change:{content:function(t){a.html(t)}},get:{html:function(){return O.removeData(S.html),O.data(S.html)||T.html},title:function(){return O.removeData(S.title),O.data(S.title)||T.title},content:function(){return O.removeData(S.content),O.data(S.content)||O.attr("title")||T.content},variation:function(){return O.removeData(S.variation),O.data(S.variation)||T.variation},popup:function(){return a},popupOffset:function(){return a.offset()},calculations:function(){var t,o=H[0],n=R[0]==e,i=T.inline||T.popup&&T.movePopup?H.position():H.offset(),r=n?{top:0,left:0}:R.offset(),s={},l=n?{top:p.scrollTop(),left:p.scrollLeft()}:{top:0,left:0};return s={target:{element:H[0],width:H.outerWidth(),height:H.outerHeight(),top:i.top,left:i.left,margin:{}},popup:{width:a.outerWidth(),height:a.outerHeight()},parent:{width:v.outerWidth(),height:v.outerHeight()},screen:{top:r.top,left:r.left,scroll:{top:l.top,left:l.left},width:R.width(),height:R.height()}},T.setFluidWidth&&C.is.fluid()&&(s.container={width:a.parent().outerWidth()},s.popup.width=s.container.width),s.target.margin.top=T.inline?parseInt(e.getComputedStyle(o).getPropertyValue("margin-top"),10):0,s.target.margin.left=T.inline?C.is.rtl()?parseInt(e.getComputedStyle(o).getPropertyValue("margin-right"),10):parseInt(e.getComputedStyle(o).getPropertyValue("margin-left"),10):0,t=s.screen,s.boundary={top:t.top+t.scroll.top,bottom:t.top+t.scroll.top+t.height,left:t.left+t.scroll.left,right:t.left+t.scroll.left+t.width},s},id:function(){return y},startEvent:function(){return"hover"==T.on?"mouseenter":"focus"==T.on&&"focus"},scrollEvent:function(){return"scroll"},endEvent:function(){return"hover"==T.on?"mouseleave":"focus"==T.on&&"blur"},distanceFromBoundary:function(t,e){var o,n,i={};return e=e||C.get.calculations(),o=e.popup,n=e.boundary,t&&(i={top:t.top-n.top,left:t.left-n.left,right:n.right-(t.left+o.width),bottom:n.bottom-(t.top+o.height)},C.verbose("Distance from boundaries determined",t,i)),i},offsetParent:function(e){var o=e!==n?e[0]:O[0],i=o.parentNode,r=t(i);if(i)for(var a="none"===r.css("transform"),s="static"===r.css("position"),p=r.is("html");i&&!p&&s&&a;)i=i.parentNode,r=t(i),a="none"===r.css("transform"),s="static"===r.css("position"),p=r.is("html");return r&&r.length>0?r:t()},positions:function(){return{"top left":!1,"top center":!1,"top right":!1,"bottom left":!1,"bottom center":!1,"bottom right":!1,"left center":!1,"right center":!1}},nextPosition:function(t){var e=t.split(" "),o=e[0],n=e[1],i={top:"bottom",bottom:"top",left:"right",right:"left"},r={left:"center",center:"right",right:"left"},a={"top left":"top center","top center":"top right","top right":"right center","right center":"bottom right","bottom right":"bottom center","bottom center":"bottom left","bottom left":"left center","left center":"top left"},s="top"==o||"bottom"==o,p=!1,l=!1,u=!1;return M||(C.verbose("All available positions available"),M=C.get.positions()),C.debug("Recording last position tried",t),M[t]=!0,"opposite"===T.prefer&&(u=[i[o],n],u=u.join(" "),p=M[u]===!0,C.debug("Trying opposite strategy",u)),"adjacent"===T.prefer&&s&&(u=[o,r[n]],u=u.join(" "),l=M[u]===!0,C.debug("Trying adjacent strategy",u)),(l||p)&&(C.debug("Using backup position",u),u=a[t]),u}},set:{position:function(t,e){if(0===H.length||0===a.length)return void C.error(k.notFound);var o,i,r,s,p,l,u,c;if(e=e||C.get.calculations(),t=t||O.data(S.position)||T.position,o=O.data(S.offset)||T.offset,i=T.distanceAway,r=e.target,s=e.popup,p=e.parent,0===r.width&&0===r.height&&!C.is.svg(r.element))return C.debug("Popup target is hidden, no action taken"),!1;switch(T.inline&&(C.debug("Adding margin to calculation",r.margin),"left center"==t||"right center"==t?(o+=r.margin.top,i+=-r.margin.left):"top left"==t||"top center"==t||"top right"==t?(o+=r.margin.left,i-=r.margin.top):(o+=r.margin.left,i+=r.margin.top)),C.debug("Determining popup position from calculations",t,e),C.is.rtl()&&(t=t.replace(/left|right/g,function(t){return"left"==t?"right":"left"}),C.debug("RTL: Popup position updated",t)),N==T.maxSearchDepth&&"string"==typeof T.lastResort&&(t=T.lastResort),t){case"top left":l={top:"auto",bottom:p.height-r.top+i,left:r.left+o,right:"auto"};break;case"top center":l={bottom:p.height-r.top+i,left:r.left+r.width/2-s.width/2+o,top:"auto",right:"auto"};break;case"top right":l={bottom:p.height-r.top+i,right:p.width-r.left-r.width-o,top:"auto",left:"auto"};break;case"left center":l={top:r.top+r.height/2-s.height/2+o,right:p.width-r.left+i,left:"auto",bottom:"auto"};break;case"right center":l={top:r.top+r.height/2-s.height/2+o,left:r.left+r.width+i,bottom:"auto",right:"auto"};break;case"bottom left":l={top:r.top+r.height+i,left:r.left+o,bottom:"auto",right:"auto"};break;case"bottom center":l={top:r.top+r.height+i,left:r.left+r.width/2-s.width/2+o,bottom:"auto",right:"auto"};break;case"bottom right":l={top:r.top+r.height+i,right:p.width-r.left-r.width-o,left:"auto",bottom:"auto"}}if(l===n&&C.error(k.invalidPosition,t),C.debug("Calculated popup positioning values",l),a.css(l).removeClass(x.position).addClass(t).addClass(x.loading),u=C.get.popupOffset(),c=C.get.distanceFromBoundary(u,e),C.is.offstage(c,t)){if(C.debug("Position is outside viewport",t),N<T.maxSearchDepth)return N++,t=C.get.nextPosition(t),C.debug("Trying new position",t),!!a&&C.set.position(t,e);if(!T.lastResort)return C.debug("Popup could not find a position to display",a),C.error(k.cannotPlace,G),C.remove.attempts(),C.remove.loading(),C.reset(),T.onUnplaceable.call(a,G),!1;C.debug("No position found, showing with last position")}return C.debug("Position is on stage",t),C.remove.attempts(),C.remove.loading(),T.setFluidWidth&&C.is.fluid()&&C.set.fluidWidth(e),!0},fluidWidth:function(t){t=t||C.get.calculations(),C.debug("Automatically setting element width to parent width",t.parent.width),a.css("width",t.container.width)},variation:function(t){t=t||C.get.variation(),t&&C.has.popup()&&(C.verbose("Adding variation to popup",t),a.addClass(t))},visible:function(){O.addClass(x.visible)}},remove:{loading:function(){a.removeClass(x.loading)},variation:function(t){t=t||C.get.variation(),t&&(C.verbose("Removing variation",t),a.removeClass(t))},visible:function(){O.removeClass(x.visible)},attempts:function(){C.verbose("Resetting all searched positions"),N=0,M=!1}},bind:{events:function(){C.debug("Binding popup events to module"),"click"==T.on&&O.on("click"+A,C.toggle),"hover"==T.on&&c&&O.on("touchstart"+A,C.event.touchstart),C.get.startEvent()&&O.on(C.get.startEvent()+A,C.event.start).on(C.get.endEvent()+A,C.event.end),T.target&&C.debug("Target set to element",H),p.on("resize"+w,C.event.resize)},popup:function(){C.verbose("Allowing hover events on popup to prevent closing"),a&&C.has.popup()&&a.on("mouseenter"+A,C.event.start).on("mouseleave"+A,C.event.end)},close:function(){(T.hideOnScroll===!0||"auto"==T.hideOnScroll&&"click"!=T.on)&&F.one(C.get.scrollEvent()+w,C.event.hideGracefully),"hover"==T.on&&W&&(C.verbose("Binding popup close event to document"),s.on("touchstart"+w,function(t){C.verbose("Touched away from popup"),C.event.hideGracefully.call(G,t)})),"click"==T.on&&T.closable&&(C.verbose("Binding popup close event to document"),s.on("click"+w,function(t){C.verbose("Clicked away from popup"),C.event.hideGracefully.call(G,t)}))}},unbind:{events:function(){p.off(w),O.off(A)},close:function(){s.off(w),F.off(w)}},has:{popup:function(){return a&&a.length>0}},is:{offstage:function(e,o){var n=[];return t.each(e,function(t,e){e<-T.jitter&&(C.debug("Position exceeds allowable distance from edge",t,e,o),n.push(t))}),n.length>0},svg:function(t){return C.supports.svg()&&t instanceof SVGGraphicsElement},active:function(){return O.hasClass(x.active)},animating:function(){return a!==n&&a.hasClass(x.animating)},fluid:function(){return a!==n&&a.hasClass(x.fluid)},visible:function(){return a!==n&&a.hasClass(x.visible)},dropdown:function(){return O.hasClass(x.dropdown)},hidden:function(){return!C.is.visible()},rtl:function(){return"rtl"==O.css("direction")}},reset:function(){C.remove.visible(),T.preserve?t.fn.transition!==n&&a.transition("remove transition"):C.removePopup()},setting:function(e,o){if(t.isPlainObject(e))t.extend(!0,T,e);else{if(o===n)return T[e];T[e]=o}},internal:function(e,o){if(t.isPlainObject(e))t.extend(!0,C,e);else{if(o===n)return C[e];C[e]=o}},debug:function(){!T.silent&&T.debug&&(T.performance?C.performance.log(arguments):(C.debug=Function.prototype.bind.call(console.info,console,T.name+":"),C.debug.apply(console,arguments)))},verbose:function(){!T.silent&&T.verbose&&T.debug&&(T.performance?C.performance.log(arguments):(C.verbose=Function.prototype.bind.call(console.info,console,T.name+":"),C.verbose.apply(console,arguments)))},error:function(){T.silent||(C.error=Function.prototype.bind.call(console.error,console,T.name+":"),C.error.apply(console,arguments))},performance:{log:function(t){var e,o,n;T.performance&&(e=(new Date).getTime(),n=d||e,o=e-n,d=e,f.push({Name:t[0],Arguments:[].slice.call(t,1)||"",Element:G,"Execution Time":o})),clearTimeout(C.performance.timer),C.performance.timer=setTimeout(C.performance.display,500)},display:function(){var e=T.name+":",o=0;d=!1,clearTimeout(C.performance.timer),t.each(f,function(t,e){o+=e["Execution Time"]}),e+=" "+o+"ms",u&&(e+=" '"+u+"'"),(console.group!==n||console.table!==n)&&f.length>0&&(console.groupCollapsed(e),console.table?console.table(f):t.each(f,function(t,e){console.log(e.Name+": "+e["Execution Time"]+"ms")}),console.groupEnd()),f=[]}},invoke:function(e,o,i){var a,s,p,l=I;return o=o||m,i=G||i,"string"==typeof e&&l!==n&&(e=e.split(/[\. ]/),a=e.length-1,t.each(e,function(o,i){var r=o!=a?i+e[o+1].charAt(0).toUpperCase()+e[o+1].slice(1):e;if(t.isPlainObject(l[r])&&o!=a)l=l[r];else{if(l[r]!==n)return s=l[r],!1;if(!t.isPlainObject(l[i])||o==a)return l[i]!==n&&(s=l[i],!1);l=l[i]}})),t.isFunction(s)?p=s.apply(i,o):s!==n&&(p=s),t.isArray(r)?r.push(p):r!==n?r=[r,p]:p!==n&&(r=p),s}},h?(I===n&&C.initialize(),C.invoke(g)):(I!==n&&I.invoke("destroy"),C.initialize())}),r!==n?r:this},t.fn.popup.settings={name:"Popup",silent:!1,debug:!1,verbose:!1,performance:!0,namespace:"popup",observeChanges:!0,onCreate:function(){},onRemove:function(){},onShow:function(){},onVisible:function(){},onHide:function(){},onUnplaceable:function(){},onHidden:function(){},on:"hover",boundary:e,addTouchEvents:!0,position:"top left",variation:"",movePopup:!0,target:!1,popup:!1,inline:!1,preserve:!1,hoverable:!1,content:!1,html:!1,title:!1,closable:!0,hideOnScroll:"auto",exclusive:!1,context:"body",scrollContext:e,prefer:"opposite",lastResort:!1,delay:{show:50,hide:70},setFluidWidth:!0,duration:200,transition:"scale",distanceAway:0,jitter:2,offset:0,maxSearchDepth:15,error:{invalidPosition:"The position you specified is not a valid position",cannotPlace:"Popup does not fit within the boundaries of the viewport",method:"The method you called is not defined.",noTransition:"This module requires ui transitions <https://github.com/Semantic-Org/UI-Transition>",notFound:"The target or popup you specified does not exist on the page"},metadata:{activator:"activator",content:"content",html:"html",offset:"offset",position:"position",title:"title",variation:"variation"},className:{active:"active",animating:"animating",dropdown:"dropdown",fluid:"fluid",loading:"loading",popup:"ui popup",position:"top left center bottom right",visible:"visible"},selector:{popup:".ui.popup"},templates:{escape:function(t){var e=/[&<>"'`]/g,o=/[&<>"'`]/,n={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},i=function(t){return n[t]};return o.test(t)?t.replace(e,i):t},popup:function(e){var o="",i=t.fn.popup.settings.templates.escape;return typeof e!==n&&(typeof e.title!==n&&e.title&&(e.title=i(e.title),o+='<div class="header">'+e.title+"</div>"),typeof e.content!==n&&e.content&&(e.content=i(e.content),o+='<div class="content">'+e.content+"</div>")),o}}}}(jQuery,window,document);